/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.MenuInfo;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.udf.UDFBlock;
import javax.swing.JPopupMenu;

public class BlockMenuInfo
extends MenuInfo {
    LogoAction fRemoteChangeParamAction = null;

    public BlockMenuInfo(Editor editor, boolean isMacroBlock) {
        super(editor);
        this.fPopupMenu = new LogoJPopupMenu();
        ActionFactory actionFactory = editor.getActionManager().getActionFactory();
        this.fPopupMenu.add(actionFactory.getAction("EditBlockPropertiesAction"));
        this.fRemoteChangeParamAction = actionFactory.getAction("RemoteChangeParamAction");
        this.fPopupMenu.add(this.fRemoteChangeParamAction);
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add(actionFactory.getAction("CutAction"));
        this.fPopupMenu.add(actionFactory.getAction("CopyAction"));
        this.fPopupMenu.add(actionFactory.getAction("DeleteFiguresAction"));
        this.fPopupMenu.addSeparator();
        if (isMacroBlock) {
            this.fPopupMenu.add(actionFactory.getAction("NewDrawingFromUDFAction"));
            this.fPopupMenu.add(actionFactory.getAction("UpdateUDFAction"));
            this.fPopupMenu.addSeparator();
        }
        this.fPopupMenu.add(actionFactory.getAction("MarkAllFiguresAction"));
        this.addHelp(this.getHelpAction());
    }

    public JPopupMenu getPopupMenu(Object object) {
        Block block = ((BlockFigure)object).getBlock();
        this.getHelpAction().setHelpID(block.getHelpIDString());
        Hardware hw = block.getWiringDiagram().getHardware();
        if (!hw.supports("SupportParamSync") || !(block instanceof SpecialBlock) && !(block instanceof UDFBlock) || block instanceof MessageBlock) {
            this.fRemoteChangeParamAction.setActivated(false);
            this.fRemoteChangeParamAction.setActivatedInCurrentContext(false);
        } else if (this.fEditor instanceof LogoComfort) {
            this.fRemoteChangeParamAction.changeContext(((LogoComfort)this.fEditor).tool().getClass());
        } else {
            this.fRemoteChangeParamAction.changeContext(Object.class);
        }
        return this.fPopupMenu;
    }
}

